using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>John Vrooland</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/21/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///Get the ship date for an outgoing shipment.
	///</summary>
	public class DlgGetShipmentDate : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables
        /// <summary>
        /// The invoice we are operating on.
        /// </summary>
		private BOL.OutgoingShipmentCollection _invoice;

		#endregion

		#region Form Controls
		//
		private System.Windows.Forms.GroupBox grpPicture;
		private System.Windows.Forms.GroupBox grpInvoice;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Label lblInvoiceNo;
		private System.Windows.Forms.Label lblFacilityName;
		private System.Windows.Forms.Label lblCityState;
		private System.Windows.Forms.Label lblShipDateTime;
		private System.Windows.Forms.TextBox txtInvoiceNo;
		private System.Windows.Forms.TextBox txtFacilityName;
		private System.Windows.Forms.TextBox txtCityState;
		private System.Windows.Forms.DateTimePicker dtpShipmentDate;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructor/Dispose
		/// <summary>
		/// Prevent instantiation of no-argument constructor.
		/// </summary>
		private DlgGetShipmentDate()
		{
            // This call is required by the Windows Form Designer.
            InitializeComponent();
			SetComponentProperties();
        }
		/// <summary>
		/// Instantiate a request for invoice ship date.
		/// </summary>
		/// <param name="invoice">The invoice being shipped.</param>
		public DlgGetShipmentDate(BOL.OutgoingShipmentCollection invoice) : this()
		{
			//
			_invoice = invoice;
			txtFacilityName.Text = invoice.FacilityName;
			txtInvoiceNo.Text = invoice.InvoiceNumber;
			txtCityState.Text = invoice.LocalSupplier.Address.City + ", " + invoice.LocalSupplier.Address.StateCode;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgGetShipmentDate));
			this.grpPicture = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpInvoice = new System.Windows.Forms.GroupBox();
			this.dtpShipmentDate = new System.Windows.Forms.DateTimePicker();
			this.txtCityState = new System.Windows.Forms.TextBox();
			this.txtFacilityName = new System.Windows.Forms.TextBox();
			this.txtInvoiceNo = new System.Windows.Forms.TextBox();
			this.lblShipDateTime = new System.Windows.Forms.Label();
			this.lblCityState = new System.Windows.Forms.Label();
			this.lblFacilityName = new System.Windows.Forms.Label();
			this.lblInvoiceNo = new System.Windows.Forms.Label();
			this.btnOK = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpPicture.SuspendLayout();
			this.grpInvoice.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(400, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Shipment Date Entry";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 177);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// grpPicture
			// 
			this.grpPicture.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpPicture.Controls.Add(this.pictureBox1);
			this.grpPicture.Location = new System.Drawing.Point(4, 32);
			this.grpPicture.Name = "grpPicture";
			this.grpPicture.Size = new System.Drawing.Size(52, 123);
			this.grpPicture.TabIndex = 4;
			this.grpPicture.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Dock = System.Windows.Forms.DockStyle.Top;
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(3, 16);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpInvoice
			// 
			this.grpInvoice.AccessibleDescription = "Confirm Shipment Date";
			this.grpInvoice.AccessibleName = "Confirm Shipment Date";
			this.grpInvoice.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpInvoice.Controls.Add(this.dtpShipmentDate);
			this.grpInvoice.Controls.Add(this.txtCityState);
			this.grpInvoice.Controls.Add(this.txtFacilityName);
			this.grpInvoice.Controls.Add(this.txtInvoiceNo);
			this.grpInvoice.Controls.Add(this.lblShipDateTime);
			this.grpInvoice.Controls.Add(this.lblCityState);
			this.grpInvoice.Controls.Add(this.lblFacilityName);
			this.grpInvoice.Controls.Add(this.lblInvoiceNo);
			this.grpInvoice.Location = new System.Drawing.Point(60, 32);
			this.grpInvoice.Name = "grpInvoice";
			this.grpInvoice.Size = new System.Drawing.Size(334, 123);
			this.grpInvoice.TabIndex = 0;
			this.grpInvoice.TabStop = false;
			this.grpInvoice.Text = "Confirm Shipment Date";
			// 
			// dtpShipmentDate
			// 
			this.dtpShipmentDate.AccessibleDescription = "Shipment Date";
			this.dtpShipmentDate.AccessibleName = "Shipment Date";
			this.dtpShipmentDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpShipmentDate.Cursor = System.Windows.Forms.Cursors.Hand;
			this.dtpShipmentDate.CustomFormat = "";
			this.dtpShipmentDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpShipmentDate.Location = new System.Drawing.Point(120, 96);
			this.dtpShipmentDate.MaxDate = new System.DateTime(2045, 12, 31, 0, 0, 0, 0);
			this.dtpShipmentDate.MinDate = new System.DateTime(2002, 1, 1, 0, 0, 0, 0);
			this.dtpShipmentDate.Name = "dtpShipmentDate";
			this.dtpShipmentDate.Size = new System.Drawing.Size(186, 20);
			this.dtpShipmentDate.TabIndex = 3;
			// 
			// txtCityState
			// 
			this.txtCityState.AccessibleDescription = "City State";
			this.txtCityState.AccessibleName = "City State";
			this.txtCityState.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtCityState.Location = new System.Drawing.Point(120, 72);
			this.txtCityState.Name = "txtCityState";
			this.txtCityState.ReadOnly = true;
			this.txtCityState.Size = new System.Drawing.Size(186, 20);
			this.txtCityState.TabIndex = 2;
			this.txtCityState.Text = "";
			// 
			// txtFacilityName
			// 
			this.txtFacilityName.AccessibleDescription = "Ship To Facility";
			this.txtFacilityName.AccessibleName = "Ship To Facility";
			this.txtFacilityName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFacilityName.Location = new System.Drawing.Point(120, 48);
			this.txtFacilityName.Name = "txtFacilityName";
			this.txtFacilityName.ReadOnly = true;
			this.txtFacilityName.Size = new System.Drawing.Size(186, 20);
			this.txtFacilityName.TabIndex = 1;
			this.txtFacilityName.Text = "";
			// 
			// txtInvoiceNo
			// 
			this.txtInvoiceNo.AccessibleDescription = "Invoice Number";
			this.txtInvoiceNo.AccessibleName = "Invoice Number";
			this.txtInvoiceNo.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtInvoiceNo.Location = new System.Drawing.Point(120, 24);
			this.txtInvoiceNo.Name = "txtInvoiceNo";
			this.txtInvoiceNo.ReadOnly = true;
			this.txtInvoiceNo.Size = new System.Drawing.Size(186, 20);
			this.txtInvoiceNo.TabIndex = 0;
			this.txtInvoiceNo.Text = "";
			// 
			// lblShipDateTime
			// 
			this.lblShipDateTime.Location = new System.Drawing.Point(12, 96);
			this.lblShipDateTime.Name = "lblShipDateTime";
			this.lblShipDateTime.Size = new System.Drawing.Size(100, 20);
			this.lblShipDateTime.TabIndex = 6;
			this.lblShipDateTime.Text = "Shipment Date*";
			this.lblShipDateTime.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblCityState
			// 
			this.lblCityState.Location = new System.Drawing.Point(12, 72);
			this.lblCityState.Name = "lblCityState";
			this.lblCityState.Size = new System.Drawing.Size(96, 20);
			this.lblCityState.TabIndex = 4;
			this.lblCityState.Text = "City, State";
			this.lblCityState.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblFacilityName
			// 
			this.lblFacilityName.Location = new System.Drawing.Point(12, 48);
			this.lblFacilityName.Name = "lblFacilityName";
			this.lblFacilityName.Size = new System.Drawing.Size(96, 20);
			this.lblFacilityName.TabIndex = 2;
			this.lblFacilityName.Text = "Ship-To Facility";
			this.lblFacilityName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblInvoiceNo
			// 
			this.lblInvoiceNo.Location = new System.Drawing.Point(12, 24);
			this.lblInvoiceNo.Name = "lblInvoiceNo";
			this.lblInvoiceNo.Size = new System.Drawing.Size(96, 20);
			this.lblInvoiceNo.TabIndex = 0;
			this.lblInvoiceNo.Text = "Invoice Number";
			this.lblInvoiceNo.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Location = new System.Drawing.Point(238, 159);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 4;
			this.btnOK.Text = "&OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(318, 160);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 5;
			this.btnCancel.Text = "&Cancel";
			// 
			// DlgGetShipmentDate
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(400, 193);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpInvoice);
			this.Controls.Add(this.grpPicture);
			this.hlphelpChm.SetHelpKeyword(this, "Outgoing_Shipment.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(408, 220);
			this.Name = "DlgGetShipmentDate";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Shipment Date Entry";
			this.Controls.SetChildIndex(this.grpPicture, 0);
			this.Controls.SetChildIndex(this.grpInvoice, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpPicture.ResumeLayout(false);
			this.grpInvoice.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Events / Event Handlers
        /// <summary>
        /// Return the user's selection. Any date is okay.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			_invoice.ShipmentDate = dtpShipmentDate.Value;
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		#endregion

		#region Properties
        
		/// <summary>
		/// Get ShipmentDate
		/// </summary>
        public DateTime ShipmentDate
        {
            get 
            {
                return dtpShipmentDate.Value;
            }
        }
		#endregion

		#region Methods
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC011.DlgGetShipmentDate());
			//set custom date and time format
			this.dtpShipmentDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			//set current date value based on the division time zone
			this.dtpShipmentDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpShipmentDate.MaxDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
		}
		#endregion

	}
}

